using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Enums
{
    /// <summary>
    /// Application Controller Update Statuses enumeration.
    /// </summary>
    public enum ApplicationControllerUpdateStatuses : byte
    {
        /// <summary>
        /// None.
        /// </summary>
        NONE = 0x00,
        /// <summary>
        /// SUC Id updated.
        /// </summary>
        SUC_ID = 0x10,
        /// <summary>
        /// Delete done.
        /// </summary>
        DELETE_DONE = 0x20,
        /// <summary>
        /// Add done.
        /// </summary>
        ADD_DONE = 0x40,
        /// <summary>
        /// Routing pending.
        /// </summary>
        ROUTING_PENDING = 0x80,
        /// <summary>
        /// Node info request failed.
        /// </summary>
        NODE_INFO_REQ_FAILED = 0x81,
        /// <summary>
        /// Node info request done.
        /// </summary>
        NODE_INFO_REQ_DONE = 0x82,
        /// <summary>
        /// Node info received.
        /// </summary>
        NODE_INFO_RECEIVED = 0x84
    }
}
